----------------------------------------------------------------
-- 
-- Copyright (c) 1995 by Altera Corporation.  All rights reserved. 
--                                                                 
-- FILENAME     :    alt_vtl.vhd (2.2b)
-- DATE CREATED :    Fri Feb 17 15:54:24 1995
-- 
-- LIBRARY      :    alt_vtl
-- REVISION     :    1.0
-- TIME SCALE   :    1 ns
-- LOGIC SYSTEM :    IEEE-1164
-- NOTES        :    VITAL, TimingChecksOn(TRUE), XGenerationOn(FALSE), On_Detect 
-- HISTORY      :
-- 
----------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.all;

library VITAL;
use VITAL.VITAL_Timing.all;
use VITAL.VITAL_Primitives.all;

package VTABLES is

   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

   CONSTANT DFF_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  L ),
    ( H,  L,  H,  x,  H,  x,  H ),
    ( H,  H,  x,  H,  x,  x,  S ),
    ( H,  x,  x,  L,  x,  x,  H ),
    ( H,  x,  x,  H,  L,  x,  S ),
    ( x,  L,  L,  H,  H,  x,  L ));

   CONSTANT DFFE_Q_tab : VitalStateTableType := (
    ( L,  x,  x,  x,  x,  x,  x,  x,  L ),
    ( H,  H,  L,  x,  x,  H,  H,  x,  H ),
    ( H,  H,  x,  L,  x,  H,  H,  x,  H ),
    ( H,  x,  H,  H,  H,  x,  x,  x,  S ),
    ( H,  x,  x,  x,  L,  x,  x,  x,  H ),
    ( H,  x,  x,  x,  H,  L,  x,  x,  S ),
    ( H,  x,  x,  x,  H,  x,  L,  x,  S ),
    ( x,  L,  L,  x,  H,  H,  H,  x,  L ),
    ( x,  L,  x,  L,  H,  H,  H,  x,  L ));

   CONSTANT LATCH_Q_tab : VitalStateTableType := (
    ( L,  H,  x,  L ),
    ( H,  H,  x,  H ),
    ( x,  L,  x,  S ));


end VTABLES;

---- end of VITAL tables library ----

----- CELL AND1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND1 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end AND1;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND1 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND1_VITAL of AND1 is
   for AltVITAL
   end for;
end CFG_AND1_VITAL;


----- CELL AND2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND2 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC);
end AND2;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND2 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (IN2_ipd) AND (IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND2_VITAL of AND2 is
   for AltVITAL
   end for;
end CFG_AND2_VITAL;


----- CELL AND3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND3 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC);
end AND3;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND3 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND3_VITAL of AND3 is
   for AltVITAL
   end for;
end CFG_AND3_VITAL;


----- CELL AND4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND4 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC);
end AND4;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND4 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND4_VITAL of AND4 is
   for AltVITAL
   end for;
end CFG_AND4_VITAL;


----- CELL AND5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND5 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC);
end AND5;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND5 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND5_VITAL of AND5 is
   for AltVITAL
   end for;
end CFG_AND5_VITAL;


----- CELL AND6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND6 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC);
end AND6;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND6 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND6_VITAL of AND6 is
   for AltVITAL
   end for;
end CFG_AND6_VITAL;


----- CELL AND7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND7 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC);
end AND7;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND7 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND7_VITAL of AND7 is
   for AltVITAL
   end for;
end CFG_AND7_VITAL;


----- CELL AND8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND8 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC);
end AND8;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND8 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND8_VITAL of AND8 is
   for AltVITAL
   end for;
end CFG_AND8_VITAL;


----- CELL AND9 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND9 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC);
end AND9;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND9 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND9_VITAL of AND9 is
   for AltVITAL
   end for;
end CFG_AND9_VITAL;


----- CELL AND10 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND10 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC);
end AND10;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND10 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd) AND (IN10_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND10_VITAL of AND10 is
   for AltVITAL
   end for;
end CFG_AND10_VITAL;


----- CELL AND11 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND11 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC);
end AND11;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND11 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd) AND (IN10_ipd)
         AND (IN11_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND11_VITAL of AND11 is
   for AltVITAL
   end for;
end CFG_AND11_VITAL;


----- CELL AND12 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND12 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC);
end AND12;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND12 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd) AND (IN10_ipd)
         AND (IN11_ipd) AND (IN12_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND12_VITAL of AND12 is
   for AltVITAL
   end for;
end CFG_AND12_VITAL;


----- CELL AND13 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND13 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC);
end AND13;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND13 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd) AND (IN10_ipd)
         AND (IN11_ipd) AND (IN12_ipd) AND (IN13_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND13_VITAL of AND13 is
   for AltVITAL
   end for;
end CFG_AND13_VITAL;


----- CELL AND14 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND14 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC);
end AND14;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND14 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN14_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   VitalPropagateWireDelay (IN14_ipd, IN14, VitalExtendToFillDelay(tipd_IN14));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd, IN14_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd) AND (IN10_ipd)
         AND (IN11_ipd) AND (IN12_ipd) AND (IN13_ipd) AND (IN14_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE),
                 13 => (IN14_ipd'last_event, VitalExtendToFillDelay(tpd_IN14_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND14_VITAL of AND14 is
   for AltVITAL
   end for;
end CFG_AND14_VITAL;


----- CELL AND15 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND15 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN15_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN15                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC;
      IN15                           :	in    STD_LOGIC);
end AND15;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND15 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN14_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN15_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   VitalPropagateWireDelay (IN14_ipd, IN14, VitalExtendToFillDelay(tipd_IN14));
   VitalPropagateWireDelay (IN15_ipd, IN15, VitalExtendToFillDelay(tipd_IN15));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd, IN14_ipd, IN15_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd) AND (IN10_ipd)
         AND (IN11_ipd) AND (IN12_ipd) AND (IN13_ipd) AND (IN14_ipd) AND
         (IN15_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE),
                 13 => (IN14_ipd'last_event, VitalExtendToFillDelay(tpd_IN14_Y), TRUE),
                 14 => (IN15_ipd'last_event, VitalExtendToFillDelay(tpd_IN15_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND15_VITAL of AND15 is
   for AltVITAL
   end for;
end CFG_AND15_VITAL;


----- CELL AND16 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity AND16 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN15_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN16_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN15                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN16                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC;
      IN15                           :	in    STD_LOGIC;
      IN16                           :	in    STD_LOGIC);
end AND16;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND16 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN14_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN15_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN16_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   VitalPropagateWireDelay (IN14_ipd, IN14, VitalExtendToFillDelay(tipd_IN14));
   VitalPropagateWireDelay (IN15_ipd, IN15, VitalExtendToFillDelay(tipd_IN15));
   VitalPropagateWireDelay (IN16_ipd, IN16, VitalExtendToFillDelay(tipd_IN16));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd, IN14_ipd, IN15_ipd, IN16_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd) AND (IN10_ipd)
         AND (IN11_ipd) AND (IN12_ipd) AND (IN13_ipd) AND (IN14_ipd) AND
         (IN15_ipd) AND (IN16_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE),
                 13 => (IN14_ipd'last_event, VitalExtendToFillDelay(tpd_IN14_Y), TRUE),
                 14 => (IN15_ipd'last_event, VitalExtendToFillDelay(tpd_IN15_Y), TRUE),
                 15 => (IN16_ipd'last_event, VitalExtendToFillDelay(tpd_IN16_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_AND16_VITAL of AND16 is
   for AltVITAL
   end for;
end CFG_AND16_VITAL;


----- CELL DELAY -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity DELAY is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end DELAY;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of DELAY is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_DELAY_VITAL of DELAY is
   for AltVITAL
   end for;
end CFG_DELAY_VITAL;


----- CELL DFF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity DFF is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_PRN_Q_negedge              :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLRN_Q_negedge             :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q_posedge              :	DelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_posedge	   :	DelayTypeXX := 0.000 ns;
      tsetup_D_CLK_negedge	   :	DelayTypeXX := 0.000 ns;
      thold_CLK_D_posedge	    :	DelayTypeXX := 0.000 ns;
      thold_CLK_D_negedge	    :	DelayTypeXX := 0.000 ns;
      tipd_D                         :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLRN                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRN                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Q                              :	out   STD_LOGIC;
      D                              :	in    STD_LOGIC;
      CLRN                           :	in    STD_LOGIC;
      PRN                            :	in    STD_LOGIC;
      CLK                            :	in    STD_LOGIC);
end DFF;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of DFF is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_LOGIC := 'X';
   SIGNAL CLRN_ipd	 : STD_LOGIC := 'X';
   SIGNAL PRN_ipd	 : STD_LOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (D_ipd, D, VitalExtendToFillDelay(tipd_D));
   VitalPropagateWireDelay (CLRN_ipd, CLRN, VitalExtendToFillDelay(tipd_CLRN));
   VitalPropagateWireDelay (PRN_ipd, PRN, VitalExtendToFillDelay(tipd_PRN));
   VitalPropagateWireDelay (CLK_ipd, CLK, VitalExtendToFillDelay(tipd_CLK));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLRN_ipd, PRN_ipd, CLK_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK	: X01 := '0';
   VARIABLE Tmkr_D_CLK	: TimeMarkerType;

   -- functionality results
   VARIABLE Violation : X01 := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(1 to 5) := (others => 'X');
   VARIABLE D_delayed : STD_LOGIC := 'X';
   VARIABLE CLK_delayed : STD_LOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: GlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalTimingCheck (D_ipd, "D", CLK_ipd, "CLK",
                           tsetup_D_CLK_posedge, tsetup_D_CLK_negedge,
                           thold_CLK_D_posedge, thold_CLK_D_negedge,
                           TO_X01(( (NOT PRN_ipd) ) OR ( (NOT CLRN_ipd) ) )
                            /= '1',
                           TO_X01(CLK_ipd) = '1',
                           InstancePath & "/DFF",
                           Tmkr_D_CLK, Tviol_D_CLK);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK;
      VitalStateTable(
        StateTable => DFF_Q_tab,
        DataIn => (
               CLRN_ipd, CLK_delayed, D_delayed, PRN_ipd, CLK_ipd),
        Result => Q_zd,
        PreviousDataIn => PrevData_Q);
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Q,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (PRN_ipd'last_event, VitalExtendToFillDelay(tpd_PRN_Q_negedge), TRUE),
                 1 => (CLRN_ipd'last_event, VitalExtendToFillDelay(tpd_CLRN_Q_negedge), TRUE),
                 2 => (CLK_ipd'last_event, VitalExtendToFillDelay(tpd_CLK_Q_posedge), TRUE),
                 3 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_CLK_Q_posedge), TRUE)),
       GlitchData => Q_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_DFF_VITAL of DFF is
   for AltVITAL
   end for;
end CFG_DFF_VITAL;


----- CELL DFFE -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity DFFE is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_PRN_Q_negedge                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLRN_Q_negedge                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q_posedge                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_ENA_Q                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_posedge   :	DelayTypeXX := 0.000 ns;
      tsetup_D_CLK_negedge   :	DelayTypeXX := 0.000 ns;
      thold_CLK_D_posedge    :	DelayTypeXX := 0.000 ns;
      thold_CLK_D_negedge    :	DelayTypeXX := 0.000 ns;
      tipd_D                         :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLRN                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRN                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_ENA                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Q                              :	out   STD_LOGIC;
      D                              :	in    STD_LOGIC;
      CLRN                           :	in    STD_LOGIC;
      PRN                            :	in    STD_LOGIC;
      CLK                            :	in    STD_LOGIC;
      ENA                            :	in    STD_LOGIC);
end DFFE;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of DFFE is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_LOGIC := 'X';
   SIGNAL CLRN_ipd	 : STD_LOGIC := 'X';
   SIGNAL PRN_ipd	 : STD_LOGIC := 'X';
   SIGNAL CLK_ipd	 : STD_LOGIC := 'X';
   SIGNAL ENA_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (D_ipd, D, VitalExtendToFillDelay(tipd_D));
   VitalPropagateWireDelay (CLRN_ipd, CLRN, VitalExtendToFillDelay(tipd_CLRN));
   VitalPropagateWireDelay (PRN_ipd, PRN, VitalExtendToFillDelay(tipd_PRN));
   VitalPropagateWireDelay (CLK_ipd, CLK, VitalExtendToFillDelay(tipd_CLK));
   VitalPropagateWireDelay (ENA_ipd, ENA, VitalExtendToFillDelay(tipd_ENA));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, CLRN_ipd, PRN_ipd, CLK_ipd, ENA_ipd)

   -- timing check results
   VARIABLE Tviol_D_CLK	: X01 := '0';
   VARIABLE Tmkr_D_CLK	: TimeMarkerType;

   -- functionality results
   VARIABLE Violation : X01 := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(1 to 7) := (others => 'X');
   VARIABLE D_delayed : STD_LOGIC := 'X';
   VARIABLE CLK_delayed : STD_LOGIC := 'X';
   VARIABLE ENA_delayed : STD_LOGIC := 'X';
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: GlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalTimingCheck (D_ipd, "D", CLK_ipd, "CLK",
                           tsetup_D_CLK_posedge, tsetup_D_CLK_negedge,
                           thold_CLK_D_posedge, thold_CLK_D_negedge,
                           TO_X01(( (NOT PRN_ipd) ) OR ( (NOT CLRN_ipd) ) )
                            /= '1',
                           TO_X01(CLK_ipd) = '1',
                           InstancePath & "/DFFE",
                           Tmkr_D_CLK, Tviol_D_CLK);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_CLK;
      VitalStateTable(
        StateTable => DFFE_Q_tab,
        DataIn => (
               CLRN_ipd, D_delayed, ENA_delayed, CLK_delayed, PRN_ipd, ENA_ipd, CLK_ipd),
        Result => Q_zd,
        PreviousDataIn => PrevData_Q);
      Q_zd := Violation XOR Q_zd;
      D_delayed := D_ipd;
      CLK_delayed := CLK_ipd;
      ENA_delayed := ENA_ipd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Q,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (PRN_ipd'last_event, VitalExtendToFillDelay(tpd_PRN_Q_negedge), TRUE),
                 1 => (CLRN_ipd'last_event, VitalExtendToFillDelay(tpd_CLRN_Q_negedge), TRUE),
                 2 => (CLK_ipd'last_event, VitalExtendToFillDelay(tpd_CLK_Q_posedge), TRUE),
                 3 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_CLK_Q_posedge), TRUE),
                 4 => (ENA_ipd'last_event, VitalExtendToFillDelay(tpd_ENA_Q), TRUE)),
       GlitchData => Q_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_DFFE_VITAL of DFFE is
   for AltVITAL
   end for;
end CFG_DFFE_VITAL;


----- CELL FILTER -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity FILTER is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpw_IN1_posedge                :  DelayTypeXX := (0.000 ns);
      tpw_IN1_negedge                :  DelayTypeXX := (0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end FILTER;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of FILTER is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd)


   -- timing check variable
   VARIABLE Tviol_pw_IN1 : boolean := False;
   VARIABLE PulseCheckInfo_IN1 : DelayArrayTypeXX(0 to 1) := (1 us, 1 us);
 
   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalPeriodCheck (
                testport        => IN1,
                testportname    => "IN1",
                pw_hi_min       => tpw_IN1_posedge,
                pw_lo_min       => tpw_IN1_negedge,
                info            => PulseCheckInfo_IN1,
                Violation       => Tviol_pw_IN1,
                HeaderMsg       => InstancePath
--              Condition       => True
                );
      end if;


end process;

end AltVITAL;

configuration CFG_FILTER_VITAL of FILTER is
   for AltVITAL
   end for;
end CFG_FILTER_VITAL;


----- CELL INV -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity INV is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end INV;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of INV is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (NOT IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_INV_VITAL of INV is
   for AltVITAL
   end for;
end CFG_INV_VITAL;


----- CELL LATCH -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity LATCH is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_D_Q_posedge                        :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_ENA_Q_posedge                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_ENA_posedge   :	DelayTypeXX := 0.000 ns;
      tsetup_D_ENA_negedge   :	DelayTypeXX := 0.000 ns;
      thold_ENA_D_posedge    :	DelayTypeXX := 0.000 ns;
      thold_ENA_D_negedge    :	DelayTypeXX := 0.000 ns;
      tipd_D                         :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_ENA                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Q                              :	out   STD_LOGIC;
      D                              :	in    STD_LOGIC;
      ENA                            :	in    STD_LOGIC);
end LATCH;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of LATCH is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL D_ipd	 : STD_LOGIC := 'X';
   SIGNAL ENA_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (D_ipd, D, VitalExtendToFillDelay(tipd_D));
   VitalPropagateWireDelay (ENA_ipd, ENA, VitalExtendToFillDelay(tipd_ENA));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (D_ipd, ENA_ipd)

   -- timing check results
   VARIABLE Tviol_D_ENA	: X01 := '0';
   VARIABLE Tmkr_D_ENA	: TimeMarkerType;

   -- functionality results
   VARIABLE Violation : X01 := '0';
   VARIABLE PrevData_Q : STD_LOGIC_VECTOR(1 to 2) := (others => 'X');
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Q_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Q_GlitchData	: GlitchDataType;

   begin

      ------------------------
      --  Timing Check Section
      ------------------------
      if (TimingChecksOn) then
         VitalTimingCheck (D_ipd, "D", ENA_ipd, "ENA",
                           tsetup_D_ENA_posedge, tsetup_D_ENA_negedge,
                           thold_ENA_D_posedge, thold_ENA_D_negedge,
                           TRUE,
                           TO_X01(ENA_ipd) = '0',
                           InstancePath & "/LATCH",
                           Tmkr_D_ENA, Tviol_D_ENA);
      end if;

      -------------------------
      --  Functionality Section
      -------------------------
      Violation := Tviol_D_ENA;
      VitalStateTable(
        StateTable => LATCH_Q_tab,
        DataIn => (
               D_ipd, ENA_ipd),
        Result => Q_zd,
        PreviousDataIn => PrevData_Q);
      Q_zd := Violation XOR Q_zd;

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Q,
       OutSignalName => "Q",
       OutTemp => Q_zd,
       Paths => (0 => (D_ipd'last_event, VitalExtendToFillDelay(tpd_D_Q_posedge), TRUE),
                 1 => (ENA_ipd'last_event, VitalExtendToFillDelay(tpd_ENA_Q_posedge), TRUE)),
       GlitchData => Q_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_LATCH_VITAL of LATCH is
   for AltVITAL
   end for;
end CFG_LATCH_VITAL;


----- CELL OR1 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR1 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end OR1;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR1 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR1_VITAL of OR1 is
   for AltVITAL
   end for;
end CFG_OR1_VITAL;


----- CELL OR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR2 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC);
end OR2;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR2 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (IN2_ipd) OR (IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR2_VITAL of OR2 is
   for AltVITAL
   end for;
end CFG_OR2_VITAL;


----- CELL OR3 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR3 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC);
end OR3;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR3 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR3_VITAL of OR3 is
   for AltVITAL
   end for;
end CFG_OR3_VITAL;


----- CELL OR4 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR4 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC);
end OR4;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR4 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR4_VITAL of OR4 is
   for AltVITAL
   end for;
end CFG_OR4_VITAL;


----- CELL OR5 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR5 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC);
end OR5;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR5 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR5_VITAL of OR5 is
   for AltVITAL
   end for;
end CFG_OR5_VITAL;


----- CELL OR6 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR6 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC);
end OR6;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR6 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR6_VITAL of OR6 is
   for AltVITAL
   end for;
end CFG_OR6_VITAL;


----- CELL OR7 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR7 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC);
end OR7;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR7 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR7_VITAL of OR7 is
   for AltVITAL
   end for;
end CFG_OR7_VITAL;


----- CELL OR8 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR8 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC);
end OR8;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR8 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR8_VITAL of OR8 is
   for AltVITAL
   end for;
end CFG_OR8_VITAL;


----- CELL OR9 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR9 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC);
end OR9;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR9 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd) OR (IN9_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR9_VITAL of OR9 is
   for AltVITAL
   end for;
end CFG_OR9_VITAL;


----- CELL OR10 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR10 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC);
end OR10;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR10 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd) OR (IN9_ipd) OR (IN10_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR10_VITAL of OR10 is
   for AltVITAL
   end for;
end CFG_OR10_VITAL;


----- CELL OR11 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR11 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC);
end OR11;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR11 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd) OR (IN9_ipd) OR (IN10_ipd) OR
         (IN11_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR11_VITAL of OR11 is
   for AltVITAL
   end for;
end CFG_OR11_VITAL;


----- CELL OR12 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR12 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC);
end OR12;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR12 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd) OR (IN9_ipd) OR (IN10_ipd) OR
         (IN11_ipd) OR (IN12_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR12_VITAL of OR12 is
   for AltVITAL
   end for;
end CFG_OR12_VITAL;


----- CELL OR13 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR13 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC);
end OR13;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR13 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd) OR (IN9_ipd) OR (IN10_ipd) OR
         (IN11_ipd) OR (IN12_ipd) OR (IN13_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR13_VITAL of OR13 is
   for AltVITAL
   end for;
end CFG_OR13_VITAL;


----- CELL OR14 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR14 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC);
end OR14;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR14 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN14_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   VitalPropagateWireDelay (IN14_ipd, IN14, VitalExtendToFillDelay(tipd_IN14));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd, IN14_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd) OR (IN9_ipd) OR (IN10_ipd) OR
         (IN11_ipd) OR (IN12_ipd) OR (IN13_ipd) OR (IN14_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE),
                 13 => (IN14_ipd'last_event, VitalExtendToFillDelay(tpd_IN14_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR14_VITAL of OR14 is
   for AltVITAL
   end for;
end CFG_OR14_VITAL;


----- CELL OR15 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR15 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN15_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN15                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC;
      IN15                           :	in    STD_LOGIC);
end OR15;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR15 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN14_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN15_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   VitalPropagateWireDelay (IN14_ipd, IN14, VitalExtendToFillDelay(tipd_IN14));
   VitalPropagateWireDelay (IN15_ipd, IN15, VitalExtendToFillDelay(tipd_IN15));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd, IN14_ipd, IN15_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd) OR (IN9_ipd) OR (IN10_ipd) OR
         (IN11_ipd) OR (IN12_ipd) OR (IN13_ipd) OR (IN14_ipd) OR (IN15_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE),
                 13 => (IN14_ipd'last_event, VitalExtendToFillDelay(tpd_IN14_Y), TRUE),
                 14 => (IN15_ipd'last_event, VitalExtendToFillDelay(tpd_IN15_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR15_VITAL of OR15 is
   for AltVITAL
   end for;
end CFG_OR15_VITAL;


----- CELL OR16 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity OR16 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN15_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN16_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN15                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN16                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC;
      IN15                           :	in    STD_LOGIC;
      IN16                           :	in    STD_LOGIC);
end OR16;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of OR16 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN14_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN15_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN16_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   VitalPropagateWireDelay (IN14_ipd, IN14, VitalExtendToFillDelay(tipd_IN14));
   VitalPropagateWireDelay (IN15_ipd, IN15, VitalExtendToFillDelay(tipd_IN15));
   VitalPropagateWireDelay (IN16_ipd, IN16, VitalExtendToFillDelay(tipd_IN16));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd, IN14_ipd, IN15_ipd, IN16_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) OR (IN1_ipd) OR (IN3_ipd) OR (IN4_ipd) OR (IN5_ipd) OR
         (IN6_ipd) OR (IN7_ipd) OR (IN8_ipd) OR (IN9_ipd) OR (IN10_ipd) OR
         (IN11_ipd) OR (IN12_ipd) OR (IN13_ipd) OR (IN14_ipd) OR (IN15_ipd)
         OR (IN16_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE),
                 13 => (IN14_ipd'last_event, VitalExtendToFillDelay(tpd_IN14_Y), TRUE),
                 14 => (IN15_ipd'last_event, VitalExtendToFillDelay(tpd_IN15_Y), TRUE),
                 15 => (IN16_ipd'last_event, VitalExtendToFillDelay(tpd_IN16_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_OR16_VITAL of OR16 is
   for AltVITAL
   end for;
end CFG_OR16_VITAL;


----- CELL RISEFALL -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity RISEFALL is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end RISEFALL;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of RISEFALL is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := TO_X01(IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_RISEFALL_VITAL of RISEFALL is
   for AltVITAL
   end for;
end CFG_RISEFALL_VITAL;

----- CELL TRIBUF -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity TRIBUF is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_OE_Y                       :	DelayType01z := 
               (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      OE                             :	in    STD_LOGIC);
end TRIBUF;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of TRIBUF is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL OE_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (OE_ipd, OE, VitalExtendToFillDelay(tipd_OE));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := VitalBUFIF0 (data => IN1_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_TRIBUF_VITAL of TRIBUF is
   for AltVITAL
   end for;
end CFG_TRIBUF_VITAL;


----- CELL XOR2 -----
library IEEE;
use IEEE.STD_LOGIC_1164.all;
library VITAL;
use VITAL.VITAL_Timing.all;


-- entity declaration --
entity XOR2 is
   generic(
      TimingChecksOn: Boolean := True;
      XGenerationOn: Boolean := False;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC);
end XOR2;

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of XOR2 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := (IN2_ipd) XOR (IN1_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;

configuration CFG_XOR2_VITAL of XOR2 is
   for AltVITAL
   end for;
end CFG_XOR2_VITAL;


---- end of library ----
